

#IFDEF __STORY_DEBUG__
	Print _constEngine_ & " " & _constBuild_ & " / Page / Allocation / Page"
	Flip : WaitKey ( )
#ENDIF

Declare Function Seq_To_DB_Direct ( Page_DB ( Any ) As SEQ_Database, PIndex As Long = 0 ) As Story_Page_Type

Declare Function Allocate_Page_Header ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

Declare Function Allocate_Page_Entities ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

Declare Function Allocate_Page_Options ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

Declare Function Allocate_Page_Desc ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

Declare Function Allocate_Entity_Direct ( Entity As Story_Entity_Type, Buffer As String = "" ) As String

Declare Function Allocate_Options_Direct ( Options As Story_Option_Type, Buffer As String = "" ) As String

Declare Function Allocate_Desc_Direct ( Desc As Story_Desc_Type, Buffer As String = "" ) As String

Declare Function Allocate_Header_Direct ( Page As Story_Page_Type, Buffer As String = "" ) As String

Function Seq_To_DB_Direct ( Page_DB ( Any ) As SEQ_Database, PIndex As Long = 0 ) As Story_Page_Type

	Dim As String CI : CI = ""

	Dim As Story_Page_Type Page
	
	Dim As String PreBuffer, Queue_Buffer, Subject_Buffer

	With Page

		.Index = PIndex
		
		.Filename = Str_Replace ( "/", "\", Gamepack.Root & Gamepack.Pack & "\Assets\Page\" & PageIndex ( .Index, 3 ) & ".seq" )
		
		If Is_File ( .Filename ) = 0 Then
			Return Page
		End If
		
		SimpleWait ( "Seq To DB Direct:" & SP & "(" & SP & "Page No." & .Index & SP & ")" & SP & QUOT & .Filename & QUOT, RGBA( 0, 255, 255, 255 ) )

		.Buffer = __Direct_Buffer ( .Filename ) 

		CI = SimpleWait ( "Buffer:" & CRLF & .Buffer, RGBA ( 64, 255, 196, 255 ) )

		__Set ( Page_DB ( ), PIndex, "Index", .Index )		
		__Set ( Page_DB ( ), PIndex, "Filename", .Filename )
		
		Subject_Buffer = ""
		Queue_Buffer = .Buffer
		
		Queue_Buffer = Allocate_Page_Header ( Page_DB ( ), Page, Queue_Buffer )

		Queue_Buffer = Allocate_Page_Entities ( Page_DB ( ), Page, Queue_Buffer )

		Queue_Buffer = Allocate_Page_Options ( Page_DB ( ), Page, Queue_Buffer )

		Queue_Buffer = Allocate_Page_Desc ( Page_DB ( ), Page, Queue_Buffer )
	
	End With
	
	Return Page
	
End Function


Function Allocate_Page_Header ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String
	
	SimpleWait ( "Allocate_Page_Header" & SP & "(" & SP & "Page_DB" & SP & "(" & SP & ")" & COMMA & Page.Index & COMMA & SP & Buffer & SP & ")", RGBA ( 64, 255, 160, 255 ) )
	
	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer
		
	With Page
					
		Dim As Long PIndex = .Index
		
		Queue_Buffer = Allocate_Header_Direct ( Page, Queue_Buffer )
		
		__Set ( Page_DB ( ), PIndex, "Caption", .Caption )
		__Set ( Page_DB ( ), PIndex, "A", .A )
		__Set ( Page_DB ( ), PIndex, "B", .B )
		__Set ( Page_DB ( ), PIndex, "Sprite", .Sprite )
	
	End With
		
	Return Queue_Buffer
	
End Function

Function Allocate_Page_Entities ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

	SimpleWait ( "Allocate_Page_Entities" & SP & "(" & SP & "Page_DB" & SP & "(" & SP & ")" & COMMA & Page.Index & COMMA & SP & Buffer & SP & ")", RGBA ( 64, 255, 160, 255 ) )

	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer
	
	With Page

		Dim As Long PIndex = .Index
	
		If .A = 0 Then
			Erase .Entity
		Else
			ReDim Preserve .Entity ( 1 To .A )
		End If
				
		__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & "LBound", LBound( .Entity, 1 ) )
		__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & "UBound", UBound( .Entity, 1 ) )
				
		For EIndex As Long = 1 To UBound ( .Entity, 1 ) Step 1
			
			SimpleWait ( "For " & EIndex & " As Long = 1 To " & UBound ( .Entity, 1 ) & " Step 1", RGBA ( 255, 160, 64, 255 ) )
			
			Queue_Buffer = Allocate_Entity_Direct ( .Entity ( EIndex ), Queue_Buffer )

			With .Entity ( EIndex )

				__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "Active", .Active )
				__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "Raw", .Raw )
				__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "Element", .Element )
				__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "Count", .Count )
				__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "Mode", .Mode )
				__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "ID", .ID )
				
				.Sprite = ImageDestroy2 ( .Sprite )
				.Scaled = ImageDestroy2 ( .Scaled )

				__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "Sprite", .Sprite )
				__Set ( Page_DB ( ), PIndex, "Entity" & VARSEP & EIndex & VARSEP & "Scaled", .Scaled )
							
			End With
			
		Next EIndex
		
	End With

	Return Queue_Buffer
	
End Function

Function Allocate_Page_Options ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

	SimpleWait ( "Allocate_Page_Options" & SP & "(" & SP & "Page_DB" & SP & "(" & SP & ")" & COMMA & Page.Index & COMMA & SP & Buffer & SP & ")", RGBA ( 64, 255, 160, 255 ) )

	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer

	With Page

		Dim As Long PIndex = .Index

		ReDim .Options ( 1 To 4 )		

		__Set ( Page_DB ( ), PIndex, "Options" & VARSEP & "LBound", 1 )
		__Set ( Page_DB ( ), PIndex, "Options" & VARSEP & "UBound", UBound( .Options, 1 ) )

		For OIndex As Long = 1 To UBound ( .Options, 1 ) Step 1
			
			SimpleWait ( "For " & OIndex & " As Long = 1 To " & UBound ( .Options, 1 ) & " Step 1", RGBA ( 255, 160, 64, 255 ) )
			
			Queue_Buffer = Allocate_Options_Direct ( .Options ( OIndex ), Queue_Buffer )

			With .Options ( OIndex )

				__Set ( Page_DB ( ), PIndex, "Options" & VARSEP & OIndex & VARSEP & "Key", .Key )
				__Set ( Page_DB ( ), PIndex, "Options" & VARSEP & OIndex & VARSEP & "Dest", .Dest )
				__Set ( Page_DB ( ), PIndex, "Options" & VARSEP & OIndex & VARSEP & "Req", .Req )
				__Set ( Page_DB ( ), PIndex, "Options" & VARSEP & OIndex & VARSEP & "Caption", .Caption )
				__Set ( Page_DB ( ), PIndex, "Options" & VARSEP & OIndex & VARSEP & "Active", .Active )
			
			End With

		Next OIndex
	
	End With
	
	Return Queue_Buffer
	
End Function

Function Allocate_Page_Desc ( Page_DB ( Any ) As SEQ_Database, Page As Story_Page_Type, Buffer As String = "" ) As String

	SimpleWait ( "Allocate_Page_Desc" & SP & "(" & SP & "Page_DB" & SP & "(" & SP & ")" & COMMA & Page.Index & COMMA & SP & Buffer & SP & ")", RGBA ( 64, 255, 160, 255 ) )

	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer

	With Page

		Dim As Long PIndex = .Index

		ReDim .Desc ( 1 To 4 )		

		__Set ( Page_DB ( ), PIndex, "Desc" & VARSEP & "LBound", 1 )
		__Set ( Page_DB ( ), PIndex, "Desc" & VARSEP & "UBound", UBound( .Desc, 1 ) )
		
		For DIndex As Long = 1 To UBound ( .Desc, 1 ) Step 1				
			
			Queue_Buffer = Allocate_Desc_Direct ( .Desc ( DIndex ), Queue_Buffer )
			
			With .Desc ( DIndex )

				__Set ( Page_DB ( ), PIndex, "Desc" & VARSEP & DIndex & VARSEP & "Text", .Text )
				__Set ( Page_DB ( ), PIndex, "Desc" & VARSEP & DIndex & VARSEP & "Active", .Active )
			
			End With
			
		Next DIndex

	End With

	Return Queue_Buffer
	
End Function


Function Allocate_Entity_Direct ( Entity As Story_Entity_Type, Buffer As String = "" ) As String
	
	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer

	With Entity

		Subject_Buffer = Trim ( Prefix ( CRLF, Queue_Buffer ), QUOT )
		Queue_Buffer = Suffix ( CRLF, Queue_Buffer )
				
		.Raw = Subject_Buffer
				
		Select Case StrPos ( EQ, .Raw )
		Case 0
			.Element = "npc"
			.ID = .Raw
		Case Is > 0
			.Element = Prefix ( EQ, .Raw )
			.ID = Suffix ( EQ, .Raw )
		End Select
			
		Select Case StrPos ( COLON, .ID )
		Case 0
			.Count = 1
		Case Is > 0
			.Count = ValInt ( Prefix ( COLON, .ID ) )
			.ID = Suffix ( COLON, .ID )
		End Select
		
		Select Case StrPos ( SP, .ID )
		Case 0
			.Mode = "Normal"
			.ID = UCWords ( .ID )
		Case Is > 0
			.Mode = UCWords ( Prefix ( SP, .ID ) )
			.ID = UCWords ( Suffix ( SP, .ID ) )
		End Select
		
		Select Case .Mode
		Case "Mad", "Dead", "Normal"
		Case Else
			.ID = .ID & SP & .Mode
			.Mode = "Normal"
		End Select
		
		.Active = 0

	End With
	
	Return Queue_Buffer
	
End Function


Function Allocate_Options_Direct ( Options As Story_Option_Type, Buffer As String = "" ) As String
	
	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer

	With Options

		Subject_Buffer = Prefix ( CRLF, Queue_Buffer )
		Queue_Buffer = Suffix ( CRLF, Queue_Buffer )

		.Key = Trim ( Prefix ( COMMA, Subject_Buffer ), QUOT )
		
		Subject_Buffer = Suffix ( COMMA, Subject_Buffer )
		.Dest = ValInt ( Trim ( Prefix ( COMMA, Subject_Buffer ), QUOT ) )
		
		Subject_Buffer = Suffix ( COMMA, Subject_Buffer )
		.Req = ValInt ( Trim ( Prefix ( COMMA, Subject_Buffer ), QUOT ) )
		
		Subject_Buffer = Suffix( COMMA, Subject_Buffer )
		.Caption = Trim ( Subject_Buffer, QUOT )

		.Active = 0

		Subject_Buffer = ""
		Queue_Buffer = Suffix ( CRLF, Queue_Buffer )
	
	End With
	
	Return Queue_Buffer
	
End Function


Function Allocate_Desc_Direct ( Desc As Story_Desc_Type, Buffer As String = "" ) As String

	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer

	With Desc
		
		Subject_Buffer = Prefix ( CRLF, Queue_Buffer )
		Queue_Buffer = Suffix ( CRLF, Queue_Buffer )
			
		.Text = Trim ( Subject_Buffer, QUOT )
			
		If Len ( .Text ) > 0 Then
			.Active = 1
		Else
			.Active = 0
		End If
			
		Subject_Buffer = Prefix ( CRLF, Queue_Buffer )
		Queue_Buffer = Suffix ( CRLF, Queue_Buffer )
			
	End With

	Return Queue_Buffer
	
End Function

Function Allocate_Header_Direct ( Page As Story_Page_Type, Buffer As String = "" ) As String
	
	Dim As String Subject_Buffer, Queue_Buffer
	
	Subject_Buffer = ""
	Queue_Buffer = Buffer
		
	With Page
			
		Subject_Buffer = Prefix ( CRLF, Queue_Buffer )
		Queue_Buffer = Suffix ( CRLF, Queue_Buffer )
		
		Dim As Long PIndex = .Index
		
		.Caption = Trim ( Subject_Buffer, QUOT )
	
		Subject_Buffer = Prefix ( CRLF, Queue_Buffer )
		Queue_Buffer = Suffix ( CRLF, Queue_Buffer )
		
		.A = ValInt ( Prefix ( ",", Subject_Buffer ) )
		Subject_Buffer = Suffix ( ",", Subject_Buffer )
		
		.B = ValInt ( Prefix ( ",", Subject_Buffer ) )
		Subject_Buffer = Suffix ( ",", Subject_Buffer )

		.Sprite = Trim ( Subject_Buffer, QUOT )
	
	End With
		
	Return Queue_Buffer
	
End Function
